#version 330
#extension GL_EXT_gpu_shader4 : enable
//Stage PlayMod01.fsh  by  spookyfox
//https://www.shadertoy.com/view/MttfRH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float SKY = -1.;
float FLOOR = 0.;

float sdPlane(vec3 p, float s, float h) {
    return s * p.y + h;
}

float sdCylinder(vec3 p) {
    return length(p.xz - vec2(0, .2)) - .1;
}

float sMin(float a, float b, float k) {
    // https://iquilezles.org/articles/smin
    float h = clamp(.5 + .5 * (b - a) / k, 0., 1.);
    return mix(b, a, h) - k * h * (1. - h);
}

vec2 opU(vec2 dm1, vec2 dm2) {
    // https://www.shadertoy.com/view/Xds3zN
    return dm1.x < dm2.x ? dm1 : dm2;
}

vec2 map(vec3 p) {
    p.x = mod(p.x, 2.0) - 0.5 * 2.0;
    p.z = mod(p.z, 2.0) - 0.5 * 2.0;
    vec2 dm;
    dm = opU(vec2(sdPlane(p, 1., 1.), FLOOR), vec2(sdPlane(p, -1., 1.), FLOOR));
    dm = vec2(sMin(dm.x, sdCylinder(p), 1.), FLOOR);
   	return dm;
}

vec2 rayMarch(vec3 ro, vec3 rd) {
    // Shortest distance and material key.
    vec2 dm;
    // Current step size.
    float s = 0.;
    for (int i = 0; i < 256; i++) {
        // Current position in the scene.
        vec3 p = ro + rd * s;
        dm = map(p);
        s += dm.x;
    }
    if (dm.x > 0.1) {
        // Our ray hasn't hit anything.
        dm.y = SKY;
    }
    return vec2(s, dm.y);
}

vec3 normal(vec3 p) {
    // Tetrahedron technique
    // https://iquilezles.org/articles/normalsSDF
    float h = 0.0001;
	vec2 k = vec2(1, -1);
    return normalize(
        k.xxx * map(p + k.xxx * h).x +
        k.xyy * map(p + k.xyy * h).x +
        k.yxy * map(p + k.yxy * h).x +
        k.yyx * map(p + k.yyx * h).x);
}

// General lighting resource: http://www.sunandblackcat.com/tipFullView.php?l=eng&topicid=30
vec3 light(vec3 ro, vec3 p, vec3 l) {
	vec3 n = normal(p);
    
    // Material properties (chrome).
    // https://people.eecs.ku.edu/~jrmiller/Courses/672/InClass/3DLighting/MaterialProperties.html
    vec3 ka = vec3(.25);
    vec3 kd = vec3(.4);
    vec3 ks = vec3(.774597);
    float es = 76.8; // Larger -> smaller highlight.
    
    // Ambient.
    // https://en.wikipedia.org/wiki/Shading#Ambient_lighting
    float a = 0.5;
    
    // Diffuse.
    // https://en.wikipedia.org/wiki/Lambertian_reflectance
    float d = clamp(dot(n, normalize(l - p)), 0., 1.);
    
    // Specular.
    // https://en.wikipedia.org/wiki/Blinn%E2%80%93Phong_shading_model
    vec3 v = normalize(ro - l);
    vec3 h = normalize(v + l);
    float s;
    if (dot(n, l) > 0.) {
        // Surface is oriented to the light source.
        s = pow(clamp(dot(n, h), 0., 1.), es);
    } else {
        s = 0.;
    }

    return a * ka + d * kd + s * ks;
}

vec3 render(vec3 ro, vec3 rd) {
    vec3 c;
    // Render by coloring intersections.
    vec2 dm = rayMarch(ro, rd);
    if (dm.y == FLOOR) {
        // The intersection.
        vec3 p = ro + rd * dm.x;
        // The point light.
        vec3 l = vec3(2, 2, -2);
        c = light(ro, p, l);   
    } else {
        c = vec3(0);
    }
    // Gamma correction.
    return pow(c, vec3(0.4545));
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    // Remap xy to [-1, 1] and correct aspect ratio.
    vec2 xy = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    
    // z: Start behind the screen.
	vec3 ro = vec3(0, 0, iTime);
    // z: Go through the screen.
    vec3 rd = normalize(vec3(xy, 1));

    gl_FragColor = vec4(render(ro, rd), 1);
}
